/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import javax.sound.sampled.AudioFormat;

public abstract class AudioFloatConverter {
    public static final AudioFormat.Encoding PCM_FLOAT = new AudioFormat.Encoding("PCM_FLOAT");
    private AudioFormat format;

    public static AudioFloatConverter getConverter(AudioFormat audioFormat) {
        AudioFloatConverter audioFloatConverter = null;
        if (audioFormat.getFrameSize() == 0) {
            return null;
        }
        if (audioFormat.getFrameSize() != (audioFormat.getSampleSizeInBits() + 7) / 8 * audioFormat.getChannels()) {
            return null;
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.isBigEndian()) {
                if (audioFormat.getSampleSizeInBits() <= 8) {
                    audioFloatConverter = new AudioFloatConversion8S();
                } else if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.getSampleSizeInBits() <= 16) {
                    audioFloatConverter = new AudioFloatConversion16SB();
                } else if (audioFormat.getSampleSizeInBits() > 16 && audioFormat.getSampleSizeInBits() <= 24) {
                    audioFloatConverter = new AudioFloatConversion24SB();
                } else if (audioFormat.getSampleSizeInBits() > 24 && audioFormat.getSampleSizeInBits() <= 32) {
                    audioFloatConverter = new AudioFloatConversion32SB();
                } else if (audioFormat.getSampleSizeInBits() > 32) {
                    audioFloatConverter = new AudioFloatConversion32xSB((audioFormat.getSampleSizeInBits() + 7) / 8 - 4);
                }
            } else if (audioFormat.getSampleSizeInBits() <= 8) {
                audioFloatConverter = new AudioFloatConversion8S();
            } else if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.getSampleSizeInBits() <= 16) {
                audioFloatConverter = new AudioFloatConversion16SL();
            } else if (audioFormat.getSampleSizeInBits() > 16 && audioFormat.getSampleSizeInBits() <= 24) {
                audioFloatConverter = new AudioFloatConversion24SL();
            } else if (audioFormat.getSampleSizeInBits() > 24 && audioFormat.getSampleSizeInBits() <= 32) {
                audioFloatConverter = new AudioFloatConversion32SL();
            } else if (audioFormat.getSampleSizeInBits() > 32) {
                audioFloatConverter = new AudioFloatConversion32xSL((audioFormat.getSampleSizeInBits() + 7) / 8 - 4);
            }
        } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            if (audioFormat.isBigEndian()) {
                if (audioFormat.getSampleSizeInBits() <= 8) {
                    audioFloatConverter = new AudioFloatConversion8U();
                } else if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.getSampleSizeInBits() <= 16) {
                    audioFloatConverter = new AudioFloatConversion16UB();
                } else if (audioFormat.getSampleSizeInBits() > 16 && audioFormat.getSampleSizeInBits() <= 24) {
                    audioFloatConverter = new AudioFloatConversion24UB();
                } else if (audioFormat.getSampleSizeInBits() > 24 && audioFormat.getSampleSizeInBits() <= 32) {
                    audioFloatConverter = new AudioFloatConversion32UB();
                } else if (audioFormat.getSampleSizeInBits() > 32) {
                    audioFloatConverter = new AudioFloatConversion32xUB((audioFormat.getSampleSizeInBits() + 7) / 8 - 4);
                }
            } else if (audioFormat.getSampleSizeInBits() <= 8) {
                audioFloatConverter = new AudioFloatConversion8U();
            } else if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.getSampleSizeInBits() <= 16) {
                audioFloatConverter = new AudioFloatConversion16UL();
            } else if (audioFormat.getSampleSizeInBits() > 16 && audioFormat.getSampleSizeInBits() <= 24) {
                audioFloatConverter = new AudioFloatConversion24UL();
            } else if (audioFormat.getSampleSizeInBits() > 24 && audioFormat.getSampleSizeInBits() <= 32) {
                audioFloatConverter = new AudioFloatConversion32UL();
            } else if (audioFormat.getSampleSizeInBits() > 32) {
                audioFloatConverter = new AudioFloatConversion32xUL((audioFormat.getSampleSizeInBits() + 7) / 8 - 4);
            }
        } else if (audioFormat.getEncoding().equals(PCM_FLOAT)) {
            if (audioFormat.getSampleSizeInBits() == 32) {
                audioFloatConverter = audioFormat.isBigEndian() ? new AudioFloatConversion32B() : new AudioFloatConversion32L();
            } else if (audioFormat.getSampleSizeInBits() == 64) {
                audioFloatConverter = audioFormat.isBigEndian() ? new AudioFloatConversion64B() : new AudioFloatConversion64L();
            }
        }
        if ((audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) && audioFormat.getSampleSizeInBits() % 8 != 0) {
            audioFloatConverter = new AudioFloatLSBFilter(audioFloatConverter, audioFormat);
        }
        if (audioFloatConverter != null) {
            audioFloatConverter.format = audioFormat;
        }
        return audioFloatConverter;
    }

    public final AudioFormat getFormat() {
        return this.format;
    }

    public abstract float[] toFloatArray(byte[] var1, int var2, float[] var3, int var4, int var5);

    public final float[] toFloatArray(byte[] byArray, float[] fArray, int n, int n2) {
        return this.toFloatArray(byArray, 0, fArray, n, n2);
    }

    public final float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2) {
        return this.toFloatArray(byArray, n, fArray, 0, n2);
    }

    public final float[] toFloatArray(byte[] byArray, float[] fArray, int n) {
        return this.toFloatArray(byArray, 0, fArray, 0, n);
    }

    public final float[] toFloatArray(byte[] byArray, float[] fArray) {
        return this.toFloatArray(byArray, 0, fArray, 0, fArray.length);
    }

    public abstract byte[] toByteArray(float[] var1, int var2, int var3, byte[] var4, int var5);

    public final byte[] toByteArray(float[] fArray, int n, byte[] byArray, int n2) {
        return this.toByteArray(fArray, 0, n, byArray, n2);
    }

    public final byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray) {
        return this.toByteArray(fArray, n, n2, byArray, 0);
    }

    public final byte[] toByteArray(float[] fArray, int n, byte[] byArray) {
        return this.toByteArray(fArray, 0, n, byArray, 0);
    }

    public final byte[] toByteArray(float[] fArray, byte[] byArray) {
        return this.toByteArray(fArray, 0, fArray.length, byArray, 0);
    }

    private static class AudioFloatConversion32xUB
    extends AudioFloatConverter {
        final int xbytes;

        AudioFloatConversion32xUB(int n) {
            this.xbytes = n;
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                n4 += this.xbytes;
                fArray[n5++] = (float)(n6 -= Integer.MAX_VALUE) * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)((double)fArray[n4++] * 2.147483647E9);
                byArray[n5++] = (byte)((n6 += Integer.MAX_VALUE) >>> 24);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
                for (int j = 0; j < this.xbytes; ++j) {
                    byArray[n5++] = 0;
                }
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32xUL
    extends AudioFloatConverter {
        final int xbytes;

        AudioFloatConversion32xUL(int n) {
            this.xbytes = n;
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                n4 += this.xbytes;
                int n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
                fArray[n5++] = (float)(n6 -= Integer.MAX_VALUE) * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                n6 += Integer.MAX_VALUE;
                for (int j = 0; j < this.xbytes; ++j) {
                    byArray[n5++] = 0;
                }
                byArray[n5++] = (byte)n6;
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 24);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32xSB
    extends AudioFloatConverter {
        final int xbytes;

        AudioFloatConversion32xSB(int n) {
            this.xbytes = n;
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                n4 += this.xbytes;
                fArray[n5++] = (float)n6 * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                byArray[n5++] = (byte)(n6 >>> 24);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
                for (int j = 0; j < this.xbytes; ++j) {
                    byArray[n5++] = 0;
                }
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32xSL
    extends AudioFloatConverter {
        final int xbytes;

        AudioFloatConversion32xSL(int n) {
            this.xbytes = n;
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                n4 += this.xbytes;
                int n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
                fArray[n5++] = (float)n6 * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                for (int j = 0; j < this.xbytes; ++j) {
                    byArray[n5++] = 0;
                }
                byArray[n5++] = (byte)n6;
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 24);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32UB
    extends AudioFloatConverter {
        private AudioFloatConversion32UB() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                fArray[n5++] = (float)(n6 -= Integer.MAX_VALUE) * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                byArray[n5++] = (byte)((n6 += Integer.MAX_VALUE) >>> 24);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32UL
    extends AudioFloatConverter {
        private AudioFloatConversion32UL() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
                fArray[n5++] = (float)(n6 -= Integer.MAX_VALUE) * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                byArray[n5++] = (byte)(n6 += Integer.MAX_VALUE);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 24);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32SB
    extends AudioFloatConverter {
        private AudioFloatConversion32SB() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                fArray[n5++] = (float)n6 * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                byArray[n5++] = (byte)(n6 >>> 24);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32SL
    extends AudioFloatConverter {
        private AudioFloatConversion32SL() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
                fArray[n5++] = (float)n6 * 4.656613E-10f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 2.1474836E9f);
                byArray[n5++] = (byte)n6;
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 24);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion24UB
    extends AudioFloatConverter {
        private AudioFloatConversion24UB() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                fArray[n5++] = (float)(n6 -= 0x7FFFFF) * 1.192093E-7f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 8388607.0f);
                byArray[n5++] = (byte)((n6 += 0x7FFFFF) >>> 16);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion24UL
    extends AudioFloatConverter {
        private AudioFloatConversion24UL() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16;
                fArray[n5++] = (float)(n6 -= 0x7FFFFF) * 1.192093E-7f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)(fArray[n4++] * 8388607.0f);
                byArray[n5++] = (byte)(n6 += 0x7FFFFF);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)(n6 >>> 16);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion24SB
    extends AudioFloatConverter {
        private AudioFloatConversion24SB() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6;
                if ((n6 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF) > 0x7FFFFF) {
                    n6 -= 0x1000000;
                }
                fArray[n5++] = (float)n6 * 1.192093E-7f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6;
                if ((n6 = (int)(fArray[n4++] * 8388607.0f)) < 0) {
                    n6 += 0x1000000;
                }
                byArray[n5++] = (byte)(n6 >>> 16);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion24SL
    extends AudioFloatConverter {
        private AudioFloatConversion24SL() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6;
                if ((n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16) > 0x7FFFFF) {
                    n6 -= 0x1000000;
                }
                fArray[n5++] = (float)n6 * 1.192093E-7f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6;
                if ((n6 = (int)(fArray[n4++] * 8388607.0f)) < 0) {
                    n6 += 0x1000000;
                }
                byArray[n5++] = (byte)n6;
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)(n6 >>> 16);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion16UB
    extends AudioFloatConverter {
        private AudioFloatConversion16UB() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                fArray[n5++] = (float)(n6 - Short.MAX_VALUE) * 3.051851E-5f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = Short.MAX_VALUE + (int)((double)fArray[n4++] * 32767.0);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion16UL
    extends AudioFloatConverter {
        private AudioFloatConversion16UL() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                int n6 = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8;
                fArray[n5++] = (float)(n6 - Short.MAX_VALUE) * 3.051851E-5f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = Short.MAX_VALUE + (int)((double)fArray[n4++] * 32767.0);
                byArray[n5++] = (byte)n6;
                byArray[n5++] = (byte)(n6 >>> 8);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion16SB
    extends AudioFloatConverter {
        private AudioFloatConversion16SB() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                fArray[n5++] = (float)((short)(byArray[n4++] << 8 | byArray[n4++] & 0xFF)) * 3.051851E-5f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                int n6 = (int)((double)fArray[n4++] * 32767.0);
                byArray[n5++] = (byte)(n6 >>> 8);
                byArray[n5++] = (byte)n6;
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion16SL
    extends AudioFloatConverter {
        private AudioFloatConversion16SL() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2 + n3;
            for (int i = n2; i < n5; ++i) {
                fArray[i] = (float)((short)(byArray[n4++] & 0xFF | byArray[n4++] << 8)) * 3.051851E-5f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n3;
            int n5 = n + n2;
            for (int i = n; i < n5; ++i) {
                int n6 = (int)((double)fArray[i] * 32767.0);
                byArray[n4++] = (byte)n6;
                byArray[n4++] = (byte)(n6 >>> 8);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion8U
    extends AudioFloatConverter {
        private AudioFloatConversion8U() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                fArray[n5++] = (float)((byArray[n4++] & 0xFF) - 127) * 0.007874016f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                byArray[n5++] = (byte)(127.0f + fArray[n4++] * 127.0f);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion8S
    extends AudioFloatConverter {
        private AudioFloatConversion8S() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n;
            int n5 = n2;
            for (int i = 0; i < n3; ++i) {
                fArray[n5++] = (float)byArray[n4++] * 0.007874016f;
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = n3;
            for (int i = 0; i < n2; ++i) {
                byArray[n5++] = (byte)(fArray[n4++] * 127.0f);
            }
            return byArray;
        }
    }

    private static class AudioFloatConversion32B
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        FloatBuffer floatbuffer = null;

        private AudioFloatConversion32B() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n3 * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(byArray, n, n4);
            this.floatbuffer.get(fArray, n2, n3);
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n2 * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            this.floatbuffer.put(fArray, n, n2);
            this.bytebuffer.get(byArray, n3, n4);
            return byArray;
        }
    }

    private static class AudioFloatConversion32L
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        FloatBuffer floatbuffer = null;

        private AudioFloatConversion32L() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n3 * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(byArray, n, n4);
            this.floatbuffer.get(fArray, n2, n3);
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n2 * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            this.floatbuffer.put(fArray, n, n2);
            this.bytebuffer.get(byArray, n3, n4);
            return byArray;
        }
    }

    private static class AudioFloatConversion64B
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        DoubleBuffer floatbuffer = null;
        double[] double_buff = null;

        private AudioFloatConversion64B() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n3 * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(byArray, n, n4);
            if (this.double_buff == null || this.double_buff.length < n3 + n2) {
                this.double_buff = new double[n3 + n2];
            }
            this.floatbuffer.get(this.double_buff, n2, n3);
            int n5 = n2 + n3;
            for (int i = n2; i < n5; ++i) {
                fArray[i] = (float)this.double_buff[i];
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n2 * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            if (this.double_buff == null || this.double_buff.length < n + n2) {
                this.double_buff = new double[n + n2];
            }
            int n5 = n + n2;
            for (int i = n; i < n5; ++i) {
                this.double_buff[i] = fArray[i];
            }
            this.floatbuffer.put(this.double_buff, n, n2);
            this.bytebuffer.get(byArray, n3, n4);
            return byArray;
        }
    }

    private static class AudioFloatConversion64L
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        DoubleBuffer floatbuffer = null;
        double[] double_buff = null;

        private AudioFloatConversion64L() {
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            int n4 = n3 * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(byArray, n, n4);
            if (this.double_buff == null || this.double_buff.length < n3 + n2) {
                this.double_buff = new double[n3 + n2];
            }
            this.floatbuffer.get(this.double_buff, n2, n3);
            int n5 = n2 + n3;
            for (int i = n2; i < n5; ++i) {
                fArray[i] = (float)this.double_buff[i];
            }
            return fArray;
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = n2 * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < n4) {
                this.bytebuffer = ByteBuffer.allocate(n4).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            if (this.double_buff == null || this.double_buff.length < n + n2) {
                this.double_buff = new double[n + n2];
            }
            int n5 = n + n2;
            for (int i = n; i < n5; ++i) {
                this.double_buff[i] = fArray[i];
            }
            this.floatbuffer.put(this.double_buff, n, n2);
            this.bytebuffer.get(byArray, n3, n4);
            return byArray;
        }
    }

    private static class AudioFloatLSBFilter
    extends AudioFloatConverter {
        private final AudioFloatConverter converter;
        private final int offset;
        private final int stepsize;
        private final byte mask;
        private byte[] mask_buffer;

        AudioFloatLSBFilter(AudioFloatConverter audioFloatConverter, AudioFormat audioFormat) {
            int n = audioFormat.getSampleSizeInBits();
            boolean bl = audioFormat.isBigEndian();
            this.converter = audioFloatConverter;
            this.stepsize = (n + 7) / 8;
            this.offset = bl ? this.stepsize - 1 : 0;
            int n2 = n % 8;
            this.mask = n2 == 0 ? (byte)0 : (n2 == 1 ? (byte)-128 : (n2 == 2 ? (byte)-64 : (n2 == 3 ? (byte)-32 : (n2 == 4 ? (byte)-16 : (n2 == 5 ? (byte)-8 : (n2 == 6 ? (byte)-4 : (n2 == 7 ? (byte)-2 : (byte)-1)))))));
        }

        public byte[] toByteArray(float[] fArray, int n, int n2, byte[] byArray, int n3) {
            byte[] byArray2 = this.converter.toByteArray(fArray, n, n2, byArray, n3);
            int n4 = n2 * this.stepsize;
            for (int i = n3 + this.offset; i < n4; i += this.stepsize) {
                byArray[i] = (byte)(byArray[i] & this.mask);
            }
            return byArray2;
        }

        public float[] toFloatArray(byte[] byArray, int n, float[] fArray, int n2, int n3) {
            if (this.mask_buffer == null || this.mask_buffer.length < byArray.length) {
                this.mask_buffer = new byte[byArray.length];
            }
            System.arraycopy(byArray, 0, this.mask_buffer, 0, byArray.length);
            int n4 = n3 * this.stepsize;
            for (int i = n + this.offset; i < n4; i += this.stepsize) {
                this.mask_buffer[i] = (byte)(this.mask_buffer[i] & this.mask);
            }
            float[] fArray2 = this.converter.toFloatArray(this.mask_buffer, n, fArray, n2, n3);
            return fArray2;
        }
    }
}

