/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ConnectionCache;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaConnectionCache;
import java.util.Collection;
import java.util.Iterator;

public abstract class CorbaConnectionCacheBase
implements ConnectionCache,
CorbaConnectionCache {
    protected ORB orb;
    protected long timestamp = 0L;
    protected String cacheType;
    protected String monitoringName;
    protected ORBUtilSystemException wrapper;

    protected CorbaConnectionCacheBase(ORB oRB, String string, String string2) {
        this.orb = oRB;
        this.cacheType = string;
        this.monitoringName = string2;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.registerWithMonitoring();
        this.dprintCreation();
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public synchronized void stampTime(Connection connection) {
        connection.setTimeStamp(this.timestamp++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfConnections() {
        Object object = this.backingStore();
        synchronized (object) {
            return this.values().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfIdleConnections() {
        long l = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                if (((Connection)iterator.next()).isBusy()) continue;
                ++l;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfBusyConnections() {
        long l = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                if (!((Connection)iterator.next()).isBusy()) continue;
                ++l;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean reclaim() {
        try {
            Object object;
            long l = this.numberOfConnections();
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim->: " + l + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getLowWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
            }
            if (l <= (long)this.orb.getORBData().getHighWaterMark() || l < (long)this.orb.getORBData().getLowWaterMark()) {
                boolean bl = false;
                return bl;
            }
            Object object2 = object = this.backingStore();
            synchronized (object2) {
                for (int i = 0; i < this.orb.getORBData().getNumberToReclaim(); ++i) {
                    Connection connection = null;
                    long l2 = Long.MAX_VALUE;
                    for (Connection connection2 : this.values()) {
                        if (connection2.isBusy() || connection2.getTimeStamp() >= l2) continue;
                        connection = connection2;
                        l2 = connection2.getTimeStamp();
                    }
                    if (connection == null) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".reclaim: closing: " + connection);
                        }
                        connection.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint(".reclaim: connections reclaimed (" + (l - this.numberOfConnections()) + ")");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim<-: " + this.numberOfConnections());
            }
        }
    }

    public String getMonitoringName() {
        return this.monitoringName;
    }

    public abstract Collection values();

    protected abstract Object backingStore();

    protected abstract void registerWithMonitoring();

    protected void dprintCreation() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".constructor: cacheType: " + this.getCacheType() + " monitoringName: " + this.getMonitoringName());
        }
    }

    protected void dprintStatistics() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".stats: " + this.numberOfConnections() + "/total " + this.numberOfBusyConnections() + "/busy " + this.numberOfIdleConnections() + "/idle" + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getLowWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
        }
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaConnectionCacheBase", string);
    }
}

