/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;

public final class EnumEditor
implements PropertyEditor {
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private final Class type;
    private final String[] tags;
    private Object value;

    public EnumEditor(Class clazz) {
        T[] TArray = clazz.getEnumConstants();
        if (TArray == null) {
            throw new IllegalArgumentException("Unsupported " + clazz);
        }
        this.type = clazz;
        this.tags = new String[TArray.length];
        for (int i = 0; i < TArray.length; ++i) {
            this.tags[i] = ((Enum)TArray[i]).name();
        }
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        PropertyChangeListener[] propertyChangeListenerArray;
        Object object2;
        if (object != null && !this.type.isInstance(object)) {
            throw new IllegalArgumentException("Unsupported value: " + object);
        }
        Object object3 = this.listeners;
        synchronized (object3) {
            object2 = this.value;
            this.value = object;
            if (object == null ? object2 == null : object.equals(object2)) {
                return;
            }
            int n = this.listeners.size();
            if (n == 0) {
                return;
            }
            propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[n]);
        }
        object3 = new PropertyChangeEvent(this, null, object2, object);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
            propertyChangeListener.propertyChange((PropertyChangeEvent)object3);
        }
    }

    public String getAsText() {
        return this.value != null ? ((Enum)this.value).name() : "null";
    }

    public void setAsText(String string) {
        this.setValue(string != null ? Enum.valueOf(this.type, string) : null);
    }

    public String[] getTags() {
        return (String[])this.tags.clone();
    }

    public String getJavaInitializationString() {
        return this.value != null ? this.type.getName() + '.' + ((Enum)this.value).name() : "null";
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(propertyChangeListener);
        }
    }
}

