/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class UnknownExtension
extends HelloExtension {
    private final byte[] data;

    UnknownExtension(HandshakeInStream handshakeInStream, int n, ExtensionType extensionType) throws IOException {
        super(extensionType);
        this.data = new byte[n];
        if (n != 0) {
            handshakeInStream.read(this.data);
        }
    }

    int length() {
        return 4 + this.data.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putBytes16(this.data);
    }

    public String toString() {
        return "Unsupported extension " + this.type + ", data: " + Debug.toString(this.data);
    }
}

