/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSocketImpl;

public final class SSLSocketFactoryImpl
extends SSLSocketFactory {
    private static SSLContextImpl defaultContext;
    private SSLContextImpl context;

    public SSLSocketFactoryImpl() throws Exception {
        this.context = SSLContextImpl.DefaultSSLContext.getDefaultImpl();
    }

    SSLSocketFactoryImpl(SSLContextImpl sSLContextImpl) {
        this.context = sSLContextImpl;
    }

    public Socket createSocket() {
        return new SSLSocketImpl(this.context);
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return new SSLSocketImpl(this.context, string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return new SSLSocketImpl(this.context, socket, string, n, bl);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new SSLSocketImpl(this.context, inetAddress, n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return new SSLSocketImpl(this.context, string, n, inetAddress, n2);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return new SSLSocketImpl(this.context, inetAddress, n, inetAddress2, n2);
    }

    public String[] getDefaultCipherSuites() {
        return this.context.getDefaultCipherSuiteList(false).toStringArray();
    }

    public String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuiteList().toStringArray();
    }
}

