/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSocketImpl;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl sslContext;
    private byte doClientAuth = 0;
    private boolean useServerMode = true;
    private boolean enableSessionCreation = true;
    private CipherSuiteList enabledCipherSuites = null;
    private ProtocolList enabledProtocols = null;
    private boolean checkedEnabled = false;

    SSLServerSocketImpl(int n, int n2, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n, n2);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(int n, int n2, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n, n2, inetAddress);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.initServer(sSLContextImpl);
    }

    private void initServer(SSLContextImpl sSLContextImpl) throws SSLException {
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.sslContext = sSLContextImpl;
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(true);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(true);
    }

    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        this.checkedEnabled = false;
    }

    public String[] getSupportedProtocols() {
        return this.sslContext.getSuportedProtocolList().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
    }

    public boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public void setWantClientAuth(boolean bl) {
        this.doClientAuth = bl ? (byte)1 : 0;
    }

    public boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public void setUseClientMode(boolean bl) {
        if (this.useServerMode != !bl && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
            this.enabledProtocols = this.sslContext.getDefaultProtocolList(!bl);
        }
        this.useServerMode = !bl;
    }

    public boolean getUseClientMode() {
        return !this.useServerMode;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public Socket accept() throws IOException {
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.doneConnect();
        return sSLSocketImpl;
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

