/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.HashSet;
import java.util.Set;
import sun.security.ssl.CipherSuite;
import sun.security.util.AlgorithmDecomposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SSLAlgorithmDecomposer
extends AlgorithmDecomposer {
    private final boolean onlyX509;

    SSLAlgorithmDecomposer(boolean bl) {
        this.onlyX509 = bl;
    }

    SSLAlgorithmDecomposer() {
        this(false);
    }

    private Set<String> decomposes(CipherSuite.KeyExchange keyExchange) {
        HashSet<String> hashSet = new HashSet<String>();
        switch (keyExchange) {
            case K_NULL: {
                if (this.onlyX509) break;
                hashSet.add("K_NULL");
                break;
            }
            case K_RSA: {
                hashSet.add("RSA");
                break;
            }
            case K_RSA_EXPORT: {
                hashSet.add("RSA");
                hashSet.add("RSA_EXPORT");
                break;
            }
            case K_DH_RSA: {
                hashSet.add("RSA");
                hashSet.add("DH");
                hashSet.add("DiffieHellman");
                hashSet.add("DH_RSA");
                break;
            }
            case K_DH_DSS: {
                hashSet.add("DSA");
                hashSet.add("DSS");
                hashSet.add("DH");
                hashSet.add("DiffieHellman");
                hashSet.add("DH_DSS");
                break;
            }
            case K_DHE_DSS: {
                hashSet.add("DSA");
                hashSet.add("DSS");
                hashSet.add("DH");
                hashSet.add("DHE");
                hashSet.add("DiffieHellman");
                hashSet.add("DHE_DSS");
                break;
            }
            case K_DHE_RSA: {
                hashSet.add("RSA");
                hashSet.add("DH");
                hashSet.add("DHE");
                hashSet.add("DiffieHellman");
                hashSet.add("DHE_RSA");
                break;
            }
            case K_DH_ANON: {
                if (this.onlyX509) break;
                hashSet.add("ANON");
                hashSet.add("DH");
                hashSet.add("DiffieHellman");
                hashSet.add("DH_ANON");
                break;
            }
            case K_ECDH_ECDSA: {
                hashSet.add("ECDH");
                hashSet.add("ECDSA");
                hashSet.add("ECDH_ECDSA");
                break;
            }
            case K_ECDH_RSA: {
                hashSet.add("ECDH");
                hashSet.add("RSA");
                hashSet.add("ECDH_RSA");
                break;
            }
            case K_ECDHE_ECDSA: {
                hashSet.add("ECDHE");
                hashSet.add("ECDSA");
                hashSet.add("ECDHE_ECDSA");
                break;
            }
            case K_ECDHE_RSA: {
                hashSet.add("ECDHE");
                hashSet.add("RSA");
                hashSet.add("ECDHE_RSA");
                break;
            }
            case K_ECDH_ANON: {
                if (this.onlyX509) break;
                hashSet.add("ECDH");
                hashSet.add("ANON");
                hashSet.add("ECDH_ANON");
                break;
            }
            case K_KRB5: {
                if (this.onlyX509) break;
                hashSet.add("KRB5");
                break;
            }
            case K_KRB5_EXPORT: {
                if (this.onlyX509) break;
                hashSet.add("KRB5_EXPORT");
                break;
            }
        }
        return hashSet;
    }

    private Set<String> decomposes(CipherSuite.BulkCipher bulkCipher) {
        HashSet<String> hashSet = new HashSet<String>();
        if (bulkCipher.transformation != null) {
            hashSet.addAll(super.decompose(bulkCipher.transformation));
        }
        if (bulkCipher == CipherSuite.B_NULL) {
            hashSet.add("C_NULL");
        } else if (bulkCipher == CipherSuite.B_RC2_40) {
            hashSet.add("RC2_CBC_40");
        } else if (bulkCipher == CipherSuite.B_RC4_40) {
            hashSet.add("RC4_40");
        } else if (bulkCipher == CipherSuite.B_RC4_128) {
            hashSet.add("RC4_128");
        } else if (bulkCipher == CipherSuite.B_DES_40) {
            hashSet.add("DES40_CBC");
            hashSet.add("DES_CBC_40");
        } else if (bulkCipher == CipherSuite.B_DES) {
            hashSet.add("DES_CBC");
        } else if (bulkCipher == CipherSuite.B_3DES) {
            hashSet.add("3DES_EDE_CBC");
        } else if (bulkCipher == CipherSuite.B_AES_128) {
            hashSet.add("AES_128_CBC");
        } else if (bulkCipher == CipherSuite.B_AES_256) {
            hashSet.add("AES_256_CBC");
        }
        return hashSet;
    }

    private Set<String> decomposes(CipherSuite.MacAlg macAlg, CipherSuite.BulkCipher bulkCipher) {
        HashSet<String> hashSet = new HashSet<String>();
        if (macAlg == CipherSuite.M_NULL) {
            hashSet.add("M_NULL");
        } else if (macAlg == CipherSuite.M_MD5) {
            hashSet.add("MD5");
            hashSet.add("HmacMD5");
        } else if (macAlg == CipherSuite.M_SHA) {
            hashSet.add("SHA1");
            hashSet.add("SHA-1");
            hashSet.add("HmacSHA1");
        }
        return hashSet;
    }

    private Set<String> decompose(CipherSuite.KeyExchange keyExchange, CipherSuite.BulkCipher bulkCipher, CipherSuite.MacAlg macAlg) {
        HashSet<String> hashSet = new HashSet<String>();
        if (keyExchange != null) {
            hashSet.addAll(this.decomposes(keyExchange));
        }
        if (this.onlyX509) {
            return hashSet;
        }
        if (bulkCipher != null) {
            hashSet.addAll(this.decomposes(bulkCipher));
        }
        if (macAlg != null) {
            hashSet.addAll(this.decomposes(macAlg, bulkCipher));
        }
        return hashSet;
    }

    @Override
    public Set<String> decompose(String string) {
        if (string.startsWith("SSL_") || string.startsWith("TLS_")) {
            CipherSuite cipherSuite = null;
            try {
                cipherSuite = CipherSuite.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (cipherSuite != null) {
                return this.decompose(cipherSuite.keyExchange, cipherSuite.cipher, cipherSuite.macAlg);
            }
        }
        return super.decompose(string);
    }
}

