/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, PublicKey publicKey) throws IOException {
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        try {
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator("SunTlsRsaPremasterSecret");
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(protocolVersion2.v, protocolVersion.v), secureRandom);
            this.preMaster = keyGenerator.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, secureRandom);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(generalSecurityException);
        }
    }

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, int n, PrivateKey privateKey) throws IOException {
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.encrypted = handshakeInStream.getBytes16();
        } else {
            this.encrypted = new byte[n];
            if (handshakeInStream.read(this.encrypted) != n) {
                throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
            }
        }
        try {
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(4, (Key)privateKey, new TlsRsaPremasterSecretParameterSpec(protocolVersion2.v, protocolVersion.v), secureRandom);
            this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLProtocolException("Unable to process PreMasterSecret, may be too big");
        }
        catch (Exception exception) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA premaster secret decryption error:");
                exception.printStackTrace(System.out);
            }
            throw new RuntimeException("Could not generate dummy secret", exception);
        }
    }

    int messageType() {
        return 16;
    }

    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            handshakeOutStream.putBytes16(this.encrypted);
        } else {
            handshakeOutStream.write(this.encrypted);
        }
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
    }
}

