--- xbmc/utils/CPUInfo.cpp.orig	2020-06-21 08:29:23 UTC
+++ xbmc/utils/CPUInfo.cpp
@@ -27,11 +27,14 @@
 #include "platform/linux/LinuxResourceCounter.h"
 #endif
 
-#if defined(TARGET_FREEBSD)
+#if defined(TARGET_FREEBSD) || defined(TARGET_DRAGONFLY)
 #include <sys/types.h>
 #include <sys/sysctl.h>
 #include <sys/resource.h>
 #endif
+#if defined(TARGET_DRAGONFLY)
+#include <sys/sensors.h>
+#endif
 
 #if defined(TARGET_LINUX) && defined(HAS_NEON) && !defined(TARGET_ANDROID)
 #include <fcntl.h>
@@ -587,6 +590,13 @@ float CCPUInfo::getCPUFrequency()
   if (sysctlbyname("dev.cpu.0.freq", &hz, &len, NULL, 0) != 0)
     hz = 0;
   return (float)hz;
+#elif defined(TARGET_DRAGONFLY)
+  struct sensor s;
+  size_t len = sizeof(s);
+  if (sysctlbyname("hw.sensors.cpu0.freq0", &s, &len, NULL, 0) != 0)
+    return (float)s.value / 1e6;
+  else
+    return 0.f;
 #else
   int value = 0;
   if (m_fCPUFreq && !m_cpuInfoForFreq)
@@ -765,7 +775,7 @@ bool CCPUInfo::readProcStat(unsigned lon
   else
     return false;
 #endif // TARGET_WINDOWS_STORE
-#elif defined(TARGET_FREEBSD)
+#elif defined(TARGET_FREEBSD) || defined(TARGET_DRAGONFLY)
   long *cptimes;
   size_t len;
   int i;
