$NetBSD$

--- src/racket/sconfig.h.orig	2011-11-08 21:20:17.000000000 +0000
+++ src/racket/sconfig.h
@@ -389,6 +389,53 @@
 
 #endif
 
+  /************** x86/DragonFly with gcc ****************/
+  /* note: */
+  /*  - not extensively verified but copied from FreeBSD */
+  /*  - x64 not tested */
+
+#if defined(__DragonFly__)
+ 
+# if defined(__i386__)
+#  define SCHEME_PLATFORM_LIBRARY_SUBPATH "i386-dragonfly"
+#  define REGISTER_POOR_MACHINE
+#  define MZ_USE_JIT_I386
+#  define FREEBSD_CONTROL_387
+# elif defined(__amd64__)
+# if 0 /* not yet attempted on x64 DragonFly */
+#  define SCHEME_PLATFORM_LIBRARY_SUBPATH "amd64-dragonfly"
+#  define REGISTER_POOR_MACHINE
+#  define MZ_USE_JIT_X86_64
+# endif /* 0 */
+# else
+#  error Unported platform.
+# endif
+
+/* pthreads always enabled via configure', and
+   initial pthread's stack size doesn't use rlimit: */
+# define ASSUME_FIXED_STACK_SIZE
+# define FIXED_STACK_SIZE 1048576
+
+# include "uconfig.h"
+
+# undef HAS_STANDARD_IOB
+
+# define HAS_BSD_IOB
+# define USE_UNDERSCORE_SETJMP
+# define USE_IEEE_FP_PREDS
+# define POW_HANDLES_INF_CORRECTLY
+# define USE_DYNAMIC_FDSET_SIZE
+# define SIGSET_IS_SIGNAL
+
+# define USE_TM_GMTOFF_FIELD
+# define USE_TM_ZONE_FIELD
+
+# define MZ_JIT_USE_MPROTECT
+
+# define FLAGS_ALREADY_SET
+
+#endif
+
   /************** SGI/IRIX with SGI cc ****************/
 
 #if  (defined(mips) || defined(__mips)) \
