#!/bin/bash

# -c latency|max_latench|desired_cpu|deadlines_met
# -m Audio|Video|X|Gaming
awk_script="extract_data.awk"
gnuplot_script_other="interbench_other.gp"
gnuplot_script_avgl="interbench_avgl.gp"

plot_file="/tmp/$$$$tmp"
declare -A column_dict
column_dict=( ["latency"]=2 ["max_latency"]=5 ["desired_cpu"]=6 ["deadlines_met"]=7 )
column="${column_dict["latency"]}"
mode="Audio"
outfile="interbench.png"

while getopts c:m:o: opt;do
	case $opt in
		c) 
		column=${column_dict["$OPTARG"]}
		;;

		m)
		mode="$OPTARG"
		;;

		o)
		outfile="$OPTARG"
		;;

		*)
		echo "Invalid option - $opt"
		exit 1
		;;

	esac
done

shift $((OPTIND-1))
filenum=$#
echo "X	$*"|tee "$plot_file"

gawk_script_other=' BEGIN{
	FS=" "; 
	flag=0;
	i=0;
	file_num=1;
}
/.*'"$mode in the presence "'.*/ {flag = 1; next;}
/.* in the presence .*/ {if (flag == 1) nextfile;}
FNR==1 {file_num++; i = 0; flag = 0;}
NF == 7 {
	if (flag != 1)
		next;
	else{
		result[i,0]=$1;
		result[i,file_num]=$'"$column"';
		i++;
	}
}
END{
	for (j = 0; j < 8; j++){
		printf("%s\t", result[j,0]);
		for (i = 1; i <= file_num; i ++)
			printf("%s\t", result[j,i]);
		printf("\n");
	}
}' 

gawk_script_avgl=' BEGIN{
	FS=" "; 
	flag=0;
	i=0;
	file_num=1;
}
/.*'"$mode in the presence "'.*/ {flag = 1; next;}
/.* in the presence .*/ {if (flag == 1) nextfile;}
FNR==1 {file_num++; i = 0; flag = 0;}
NF == 7 {
	if (flag != 1)
		next;
	else{
		result[i,0]=$1;
		result[i,file_num]=$2"\t"$4;
		i++;
	}
}
END{
	for (j = 0; j < 8; j++){
		printf("%s\t", result[j,0]);
		for (i = 1; i <= file_num; i ++)
			printf("%s\t", result[j,i]);
		printf("\n");
	}
}' 

if [ "$column" -eq 2 ];then
	gawk_script=$gawk_script_avgl
	gnuplot_script=$gnuplot_script_avgl
	col=$((filenum*2+1))
else
	gawk_script=$gawk_script_other
	gnuplot_script=$gnuplot_script_other
	col=$((filenum+1))
fi

gawk "$gawk_script" $* |tee -a "$plot_file"
	
sed -e "s?__COL__?$col?"	\
	-e "s?__MODE__?$mode?"	\
	-e "s?__FILENAME__?$plot_file?"	\
	"$gnuplot_script" | gnuplot > $outfile

#rm -f "$plot_file"	

exit 0
